//  Inpu/output pin designations for PIC board
//  07/22/08
//  emdash@mit.edu

/*
23 of the dsPIC's I/O pins are designated below as 
"inputs."  These pins are connected to headers on
the left-hand side of the PCB.  They also include the 18 pins 
that may be used as analog inputs.  Named L1 through L23.

24 other pins are designated as "outputs."  Named R1 through R24. 
(headers on right-hand side of PCB)


CHANGING A PIN DESIGNATION FROM DEFAULT
Ex: To change "L1" (pin G15) to be an output:
change L1 = INPUT; 
to L1 = OUTPUT;
*/


#define OUTPUT 0
#define INPUT 1



#define L1 _LATB0
#define L2 _LATB1
#define L3 _LATB2
#define L4 _LATB3
#define L5 _LATB4
#define L6 _LATB5
#define L7 _LATB6  	// PGC1 for ICSP, avoid using
#define L8 _LATB7  	// PGD1 for ICSP, avoid using
#define L9 _LATB8
#define L10 _LATB9
#define L11 _LATB10
#define L12 _LATB11  
#define L13 _LATB12
#define L14 _LATB13 
#define L15 _LATB14
#define L16 _LATB15




#define R1 _LATG9
#define R2 _LATG8
#define R3 _LATG7
#define R4 _LATG6
#define R5 _LATG15
#define R6 _LATG13
#define R7 _LATG12
#define R8 _LATG14
#define R9 _LATG0
#define R10 _LATG1
#define R11 _LATF1
#define R12 _LATF0
#define R13 _LATD7
#define R14 _LATD6
#define R15 _LATD5
#define R16 _LATD4
#define R17 _LATD3
#define R18 _LATD2
#define R19 _LATD1
#define R20 _LATC14
#define R21 _LATC13
#define R22 _LATD0
#define R23 _LATD11
#define R24 _LATD10
#define R25 _LATD8
#define R26 _LATG2
#define R27 _LATG3
#define R28 _LATF5
#define R29 _LATF2




void allOn(void);
void allOff(void);




void allOn (void) {
R1 = 1;
R2 = 1;
R3 = 1;
R4 = 1;
R5 = 1;
R6 = 1;
R7 = 1;
R8 = 1;
R9 = 1;
R10 = 1;
R11 = 1;
R12 = 1;

R13 = 1;
R14 = 1;
R15 = 1;
R16 = 1;
R17 = 1;
R18 = 1;
R19 = 1;
R20 = 1;
R21 = 1;
R22 = 1;
R23 = 1;
R24 = 1;
}

void allOff (void) {
R1 = 0;
R2 = 0;
R3 = 0;
R4 = 0;
R5 = 0;
R6 = 0;
R7 = 0;
R8 = 0;
R9 = 0;
R10 = 0;
R11 = 0;
R12 = 0;

R13 = 0;
R14 = 0;
R15 = 0;
R16 = 0;
R17 = 0;
R18 = 0;
R19 = 0;
R20 = 0;
R21 = 0;
R22 = 0;
R23 = 0;
R24 = 0;
}

